/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server;

import ch.uyuno.printcontrol.server.ComunicationObject;
import ch.uyuno.printcontrol.server.Mailbox;
import ch.uyuno.printcontrol.server.Utilities;
import ch.uyuno.printcontrol.server.ethernet.EthernetManager;
import ch.uyuno.printcontrol.server.ethernet.EthernetUtilities;
import ch.uyuno.serialinterface.Frame;
import ch.uyuno.serialinterface.ISerialListener;
import ch.uyuno.serialinterface.SerialManager;
import ch.uyuno.serialinterface.SerialUtilities;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class CommunicationManager
implements Runnable {
    private final int MAX_TRY = 3;
    private static CommunicationManager singelton;
    private SerialManager serial;
    private EthernetManager[] ethernet = new EthernetManager[5];
    private Mailbox<ComunicationObject> mailbox = new Mailbox();
    private Frame ReceiveFrame;
    private boolean EnEthernet = true;
    public static final int MAX_MACHINES = 5;
    public int maxMachines = 1;
    private boolean newReceiveFrame;

    public static CommunicationManager getManager() {
        if (singelton == null) {
            singelton = new CommunicationManager();
        }
        return singelton;
    }

    private CommunicationManager() {
        this.serial = SerialManager.getSerialManager();
        this.serial.addListener(new ISerialListener(){

            public void receive(Frame frame) {
                CommunicationManager.this.FrameIn(frame);
            }
        });
        int i = 1;
        while (i <= 5) {
            this.ethernet[i - 1] = EthernetManager.getEthernetManager((byte)i);
            this.ethernet[i - 1].addListener(new ISerialListener(){

                public void receive(Frame frame) {
                    CommunicationManager.this.FrameIn(frame);
                }
            });
            ++i;
        }
        this.newReceiveFrame = false;
        new Thread((Runnable)this, "CommunicationManager").start();
    }

    private void FrameIn(Frame frame) {
        if (!this.newReceiveFrame) {
            this.ReceiveFrame = frame;
            this.newReceiveFrame = true;
        }
    }

    public int getMaxMachine() {
        if (this.maxMachines > 5) {
            this.maxMachines = 5;
        } else if (this.maxMachines < 1) {
            this.maxMachines = 1;
        }
        return this.maxMachines;
    }

    public boolean isPortOpen() {
        boolean result = false;
        if (!this.EnEthernet) {
            result = this.serial.isPortOpen();
        } else {
            int i = 1;
            while (i <= 5) {
                if (this.ethernet[i - 1].isPortOpen()) {
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean openPort() {
        boolean result = false;
        IPreferencesService service = Platform.getPreferencesService();
        String sMaxMachines = service.getString("ch.uyuno.printcontrol.server", "ch.uyuno.printcontrol.server.NbrOfMachine", "Undef", null);
        try {
            this.maxMachines = Integer.parseInt(sMaxMachines);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("MaxMachines not Ok");
        }
        String ComType = service.getString("ch.uyuno.printcontrol.server", "ch.uyuno.printcontrol.server.interface", "Undef", null);
        this.EnEthernet = ComType.equals("ETHERNET");
        if (!this.EnEthernet) {
            String port = service.getString("ch.uyuno.printcontrol.server", "ch.uyuno.printcontrol.server.serialport", "COM1", null);
            String baudrate = service.getString("ch.uyuno.printcontrol.server", "ch.uyuno.printcontrol.server.serialbaudrate", "57600", null);
            System.out.print("Connect : ");
            System.out.print(String.valueOf(port) + " ");
            System.out.println(baudrate);
            try {
                int baud = Integer.parseInt(baudrate);
                result = this.serial.openPort(port, baud);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Baudrate not Ok");
            }
        } else {
            String IPAddress = service.getString("ch.uyuno.printcontrol.server", "ch.uyuno.printcontrol.server.ip.1", "undef", null);
            result = this.ethernet[0].openPort(IPAddress);
            if (this.maxMachines > 1) {
                IPAddress = service.getString("ch.uyuno.printcontrol.server", "ch.uyuno.printcontrol.server.ip.2", "undef", null);
                result = this.ethernet[1].openPort(IPAddress);
                if (this.maxMachines > 2) {
                    IPAddress = service.getString("ch.uyuno.printcontrol.server", "ch.uyuno.printcontrol.server.ip.3", "undef", null);
                    result = this.ethernet[2].openPort(IPAddress);
                    if (this.maxMachines > 3) {
                        IPAddress = service.getString("ch.uyuno.printcontrol.server", "ch.uyuno.printcontrol.server.ip.4", "undef", null);
                        result = this.ethernet[3].openPort(IPAddress);
                        if (this.maxMachines > 4) {
                            IPAddress = service.getString("ch.uyuno.printcontrol.server", "ch.uyuno.printcontrol.server.ip.5", "undef", null);
                            result = this.ethernet[4].openPort(IPAddress);
                        }
                    }
                }
            }
        }
        return result;
    }

    public boolean closePort() {
        boolean result;
        if (!this.EnEthernet) {
            result = this.serial.closePort();
        } else {
            result = this.ethernet[0].closePort();
            result = this.ethernet[1].closePort();
            result = this.ethernet[2].closePort();
            result = this.ethernet[3].closePort();
            result = this.ethernet[4].closePort();
        }
        return result;
    }

    public boolean blockTransfer() {
        return this.EnEthernet;
    }

    public Utilities.CommunicationERROR getError() {
        Utilities.CommunicationERROR result = Utilities.CommunicationERROR.NONE;
        if (!this.EnEthernet) {
            if (this.serial.getError() == SerialUtilities.ERROR.IN_USE) {
                result = Utilities.CommunicationERROR.IN_USE;
            } else if (this.serial.getError() == SerialUtilities.ERROR.INIT) {
                result = Utilities.CommunicationERROR.INIT;
            } else if (this.serial.getError() == SerialUtilities.ERROR.NO_SUCH_PORT) {
                result = Utilities.CommunicationERROR.NO_SUCH_PORT;
            }
        } else if (this.ethernet[0].getError() == EthernetUtilities.ERROR.IN_USE) {
            result = Utilities.CommunicationERROR.IN_USE;
        } else if (this.ethernet[0].getError() == EthernetUtilities.ERROR.INIT) {
            result = Utilities.CommunicationERROR.INIT;
        } else if (this.ethernet[0].getError() == EthernetUtilities.ERROR.NO_SUCH_HOST) {
            result = Utilities.CommunicationERROR.NO_SUCH_HOST;
        }
        return result;
    }

    public void Process(ComunicationObject co) throws InterruptedException {
        this.mailbox.put(co);
    }

    @Override
    public void run() {
        try {
            block2: while (true) {
                ComunicationObject co = this.mailbox.get();
                this.newReceiveFrame = false;
                int tryCounter = 3;
                while (true) {
                    if (this.newReceiveFrame || tryCounter <= 0) continue block2;
                    if (!this.EnEthernet) {
                        this.serial.flush();
                        this.serial.send(co.getRequestFrame());
                    } else if (co.getAddres() == 1) {
                        if (this.ethernet[0] != null) {
                            this.ethernet[0].send(co.getRequestFrame());
                        }
                    } else if (co.getAddres() == 2) {
                        if (this.ethernet[1] != null) {
                            this.ethernet[1].send(co.getRequestFrame());
                        }
                    } else if (co.getAddres() == 3) {
                        if (this.ethernet[2] != null) {
                            this.ethernet[2].send(co.getRequestFrame());
                        }
                    } else if (co.getAddres() == 4) {
                        if (this.ethernet[3] != null) {
                            this.ethernet[3].send(co.getRequestFrame());
                        }
                    } else if (co.getAddres() == 5 && this.ethernet[4] != null) {
                        this.ethernet[4].send(co.getRequestFrame());
                    }
                    int timerCounter = !this.EnEthernet ? 300 : 150;
                    while (timerCounter > 0 && !this.newReceiveFrame) {
                        Thread.sleep(2L);
                        timerCounter -= 2;
                    }
                    if (this.newReceiveFrame) {
                        co.setAnserFrame(this.ReceiveFrame);
                        continue;
                    }
                    if (--tryCounter >= 1) continue;
                    co.setAnserFrame(null);
                }
                break;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }
}

