/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.serialinterface;

import java.util.Calendar;

public class SerialDebugBuffer {
    char[] buffer;
    Calendar calendar;
    boolean isInMsg;
    int bufsize;

    SerialDebugBuffer(char[] msgBuf, int msgSize, boolean inMsg, Calendar date) {
        this.buffer = msgBuf;
        this.calendar = date;
        this.isInMsg = inMsg;
        this.bufsize = msgSize;
        if (this.bufsize > this.buffer.length) {
            this.bufsize = this.buffer.length;
        }
    }

    SerialDebugBuffer(char[] msgBuf, int msgSize, boolean inMsg) {
        this.buffer = msgBuf;
        this.calendar = Calendar.getInstance();
        this.isInMsg = inMsg;
        this.bufsize = msgSize;
        if (this.bufsize > this.buffer.length) {
            this.bufsize = this.buffer.length;
        }
    }

    private char GetHexValue(char value) {
        char result = ' ';
        if (value >= '\u0000' && value < '\n') {
            result = (char)(48 + value);
        } else if (value > '\t' && value < '\u0010') {
            result = (char)(65 + (value - 10));
        }
        return result;
    }

    public String GetHexString() {
        String result = "";
        int i = 0;
        while (i < this.bufsize) {
            result = String.valueOf(result) + this.GetHexValue((char)(this.buffer[i] >> 4 & 0xF));
            result = String.valueOf(result) + this.GetHexValue((char)(this.buffer[i] & 0xF)) + ' ';
            ++i;
        }
        return result;
    }

    public Calendar GetTime() {
        return this.calendar;
    }

    public String GetTimeStr() {
        return String.valueOf(this.calendar.get(11)) + ":" + this.calendar.get(12) + ":" + this.calendar.get(13) + "." + this.calendar.get(14);
    }

    public boolean isInMessage() {
        return this.isInMsg;
    }
}

