/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server.widgets;

import ch.uyuno.printcontrol.server.Activator;
import ch.uyuno.printcontrol.server.MachineAccess;
import ch.uyuno.printcontrol.server.MachineControl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class MachineWidgets {
    private IWorkbenchWindow window = null;
    private MouseListener mouselistener = new MouseListener(){

        public void mouseDown(MouseEvent e) {
            if (MachineWidgets.this.window != null) {
                try {
                    MachineWidgets.this.window.getActivePage().showView("ch.uyuno.printcontrol.server.view.applicationlistview", "" + MachineWidgets.this.MachineId, 1);
                }
                catch (PartInitException ex) {
                    MessageDialog.openError((Shell)MachineWidgets.this.window.getShell(), (String)"Error", (String)("Error opening view:" + ex.getMessage()));
                }
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    };
    private MachineControl machineControl;
    private int MachineId;
    private Composite mainComposite;
    private Label typeLabel;
    private Label imageLabel;
    private Label stateLable;

    public MachineWidgets(Composite parent, int id, IWorkbenchWindow w) {
        this.MachineId = id;
        this.window = w;
        this.machineControl = MachineControl.getMachineMainControl();
        this.mainComposite = new Composite(parent, 0x100000);
        this.mainComposite.setLayoutData((Object)new RowData(63, 102));
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.pack = true;
        layout.justify = false;
        layout.type = 512;
        layout.fill = true;
        layout.marginLeft = 4;
        layout.marginRight = 4;
        layout.marginTop = 2;
        layout.marginBottom = 2;
        layout.spacing = 2;
        this.mainComposite.setLayout((Layout)layout);
        this.mainComposite.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 127, 178, 127));
        this.mainComposite.addMouseListener(this.mouselistener);
        this.typeLabel = new Label(this.mainComposite, 0x1000000);
        this.typeLabel.setAlignment(0x1000000);
        this.typeLabel.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 127, 178, 127));
        this.typeLabel.setText("ML350");
        this.typeLabel.addMouseListener(this.mouselistener);
        this.imageLabel = new Label(this.mainComposite, 0x1000000);
        this.imageLabel.setAlignment(0x1000000);
        this.imageLabel.setImage(Activator.getImageDescriptor("/icons/ml350-small.gif").createImage());
        this.imageLabel.addMouseListener(this.mouselistener);
        this.stateLable = new Label(this.mainComposite, 0x1000000);
        this.stateLable.setAlignment(0x1000000);
        this.stateLable.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 200, 200, 200));
        this.stateLable.setText("STOP");
        this.stateLable.addMouseListener(this.mouselistener);
    }

    public boolean isDisposed() {
        return this.mainComposite.isDisposed();
    }

    private void setState(MachineAccess.STATE state) {
        if (state == MachineAccess.STATE.STOP) {
            this.stateLable.setText("STOP");
        } else if (state == MachineAccess.STATE.RUN) {
            this.stateLable.setText("RUN");
        } else if (state == MachineAccess.STATE.INIT) {
            this.stateLable.setText("INIT");
        } else if (state == MachineAccess.STATE.ERROR) {
            this.stateLable.setText("ERROR");
        } else if (state == MachineAccess.STATE.EMERGENCY_STOP) {
            this.stateLable.setText("E-STOP");
        } else if (state == MachineAccess.STATE.NO_COMMUNICATION) {
            this.stateLable.setText("NO-COM");
        } else {
            this.stateLable.setText("UNDEF");
        }
    }

    private void setType(byte family, byte subtype) {
        if (family == 1) {
            this.imageLabel.setImage(Activator.getImageDescriptor("/icons/ml350-small.gif").createImage());
            if (subtype == 1) {
                this.typeLabel.setText("ML250");
            } else if (subtype == 2) {
                this.typeLabel.setText("ML350");
            } else if (subtype == 3) {
                this.typeLabel.setText("ML500");
            } else {
                this.typeLabel.setText("MLxxx");
            }
        } else if (family == 2) {
            this.imageLabel.setImage(Activator.getImageDescriptor("/icons/Portal-small.gif").createImage());
            if (subtype == 1) {
                this.typeLabel.setText("Portal");
            } else {
                this.typeLabel.setText("Portal");
            }
        } else if (family == 3) {
            this.imageLabel.setImage(Activator.getImageDescriptor("/icons/Modul.gif").createImage());
            if (subtype == 1) {
                this.typeLabel.setText("Mod100");
            } else if (subtype == 2) {
                this.typeLabel.setText("Mod110");
            } else if (subtype == 3) {
                this.typeLabel.setText("Mod130");
            } else if (subtype == 4) {
                this.typeLabel.setText("Mod200");
            } else {
                this.typeLabel.setText("MLxxx");
            }
        } else if (family == 4) {
            this.imageLabel.setImage(Activator.getImageDescriptor("/icons/Modulanlagen.gif").createImage());
            if (subtype == 1) {
                this.typeLabel.setText("Modul5");
            }
            if (subtype == 2) {
                this.typeLabel.setText("Modul10");
            } else {
                this.typeLabel.setText("Undef");
            }
        } else {
            this.typeLabel.setText("UNDEF");
        }
    }

    public void refresh() {
        MachineAccess control = this.machineControl.GetMachineAccess(this.MachineId);
        if (control != null) {
            this.mainComposite.setVisible(true);
            this.setState(control.getState());
            this.setType(control.getFamilyType(), control.getSubType());
        } else {
            this.mainComposite.setVisible(false);
        }
    }
}

