/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.serialinterface.views;

import ch.uyuno.serialinterface.Frame;
import ch.uyuno.serialinterface.IDebugBufferChange;
import ch.uyuno.serialinterface.ISerialListener;
import ch.uyuno.serialinterface.SerialDebugBuffer;
import ch.uyuno.serialinterface.SerialManager;
import ch.uyuno.serialinterface.views.SerialInterfaceViewLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SerialDebugView
extends ViewPart {
    private TableViewer viewer;
    private SerialManager serial;
    private Table table;
    private Text sendText;
    private ISerialListener serialListener;
    private final String IN_OUT_COLUMN = "in_out";
    private final String TIME_COLUMN = "time";
    private final String DATA_COLUMN = "data";
    private String[] columnNames = new String[]{"in_out", "time", "data"};

    public SerialDebugView() {
        this.serial = SerialManager.getSerialManager();
        this.serialListener = new ISerialListener(){

            @Override
            public void receive(Frame frame) {
                int i = 0;
                while (i < frame.GetFrameSize()) {
                    System.out.print(String.valueOf(frame.GetFrameBuffer()[i]) + " ");
                    ++i;
                }
                System.out.println("");
            }
        };
        this.serial.addListener(this.serialListener);
    }

    protected void finalize() {
        this.serial.removeListener(this.serialListener);
    }

    public void createPartControl(Composite parent) {
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 4;
        parent.setLayout((Layout)layout);
        this.createRS232DataSend(parent);
        this.createTable(parent);
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Serial Interface", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createRS232DataSend(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("RS232 Data send");
        GridData gridData = new GridData(770);
        group.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 4;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText("Input:");
        gridData = new GridData(128);
        gridData.widthHint = 80;
        label.setLayoutData((Object)gridData);
        this.sendText = new Text((Composite)group, 2048);
        gridData = new GridData(2);
        gridData.widthHint = 150;
        this.sendText.setLayoutData((Object)gridData);
        this.sendText.setText("Hallo");
        Button sendButton = new Button((Composite)group, 0x1000008);
        sendButton.setText("Send");
        gridData = new GridData(128);
        gridData.widthHint = 80;
        sendButton.setLayoutData((Object)gridData);
        sendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("Send");
                System.out.println(SerialDebugView.this.sendText.getText());
                if (SerialDebugView.this.serial.isPortOpen()) {
                    byte[] buf = SerialManager.convertHexStringToByteArray(SerialDebugView.this.sendText.getText());
                    SerialDebugView.this.serial.send(new Frame(buf, buf.length));
                } else {
                    SerialDebugView.this.showMessage("Serial Port not connected");
                    System.out.println("Port Not Open");
                }
            }
        });
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0x1000000, 0);
        column.setText("in/out");
        column.setWidth(45);
        column = new TableColumn(this.table, 16384, 1);
        column.setText("Time");
        column.setWidth(80);
        column = new TableColumn(this.table, 16384, 2);
        column.setText("Data");
        column.setWidth(500);
        this.viewer = new TableViewer(this.table);
        this.viewer.setColumnProperties(this.columnNames);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SerialInterfaceViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.serial.DebugBuffer);
        this.serial.DebugBuffer.addChangeListener(new IDebugBufferChange(){

            @Override
            public void changed() {
                Display d = PlatformUI.getWorkbench().getDisplay();
                if (!d.isDisposed()) {
                    d.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!SerialDebugView.this.table.isDisposed()) {
                                SerialDebugView.this.viewer.refresh();
                            }
                        }
                    });
                }
            }
        });
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            SerialDebugBuffer buffer1 = (SerialDebugBuffer)o1;
            SerialDebugBuffer buffer2 = (SerialDebugBuffer)o2;
            return buffer2.GetTime().compareTo(buffer1.GetTime());
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((SerialDebugView)SerialDebugView.this).serial.DebugBuffer.getBuffers().toArray();
        }
    }
}

